/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.event;

import com.mojang.datafixers.util.Pair;
import com.renyigesai.immortalers_delight.client.particle.ShockWaveParticleOption;
import com.renyigesai.immortalers_delight.entities.projectile.KiBlastEntity;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightFoodProperties;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import com.renyigesai.immortalers_delight.item.food.InebriatedToxicFoodItem;
import com.renyigesai.immortalers_delight.potion.GasPoisonMobEffect;
import com.renyigesai.immortalers_delight.potion.immortaleffects.FreezeEffect;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import com.renyigesai.immortalers_delight.util.task.TimekeepingTask;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FoodItemEventHelper {
    public static final String DELETE_PIGLIN = "immortalers_delight_delete_piglin";
    public static final String EAT_THIS_SIDE_DOWN = "immortalers_delight_this_side_down_eater";

    @SubscribeEvent
    public static void onUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        if (event != null && event.getEntity() != null) {
            LivingEntity livingEntity;
            ItemStack stack = event.getItem();
            LivingEntity entity = event.getEntity();
            if (entity instanceof LivingEntity && !(livingEntity = entity).m_9236_().m_5776_() && stack.m_41720_().m_41472_()) {
                MobEffectInstance incandence;
                if (stack.getFoodProperties(livingEntity) == ImmortalersDelightFoodProperties.RED_STUFFED_BUN) {
                    if (DifficultyModeUtil.isPowerBattleMode()) {
                        if (livingEntity.m_217043_().m_188503_(3) == 0) {
                            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 6000, 3));
                            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 2700));
                        }
                    } else if (livingEntity.m_217043_().m_188503_(3) == 0) {
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 6000, 1));
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 600));
                    }
                }
                if (stack.getFoodProperties(livingEntity) == ImmortalersDelightFoodProperties.PEARLIP_BUBBLE_MILK) {
                    livingEntity.curePotionEffects(new ItemStack((ItemLike)Items.f_42455_));
                    for (Pair pair : Objects.requireNonNull(stack.getFoodProperties(livingEntity)).m_38749_()) {
                        livingEntity.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
                    }
                }
                if (stack.m_41720_() == ImmortalersDelightItems.HONG_MEI_LING.get()) {
                    FoodItemEventHelper.shootKiBlast(livingEntity);
                }
                if (stack.m_41720_() == ImmortalersDelightItems.KWAT_SOUP.get()) {
                    DamageSource damageSource;
                    float damage;
                    boolean isPowerBattleMode = DifficultyModeUtil.isPowerBattleMode();
                    float f = damage = isPowerBattleMode ? Math.min(18.0f, livingEntity.m_21233_() * 0.9f) : Math.max(18.0f, livingEntity.m_21233_() * 0.9f);
                    if (isPowerBattleMode) {
                        if (livingEntity instanceof Player) {
                            Player player = (Player)livingEntity;
                            damageSource = player.m_269291_().m_269075_(player);
                        } else {
                            damageSource = livingEntity.m_269291_().m_269333_(livingEntity);
                        }
                    } else {
                        damageSource = GasPoisonMobEffect.getDamageSource((Entity)livingEntity, null);
                    }
                    DamageSource source = damageSource;
                    livingEntity.m_6469_(source, damage);
                    if (isPowerBattleMode) {
                        livingEntity.m_7292_(new MobEffectInstance((MobEffect)ImmortalersDelightMobEffect.SATIATED.get(), 1500, 2));
                    } else {
                        livingEntity.m_7292_(new MobEffectInstance((MobEffect)ImmortalersDelightMobEffect.SATIATED.get(), 1200, 1));
                    }
                }
                if (stack.m_41720_() == ImmortalersDelightItems.ICED_KWAT_SOUP.get() && (incandence = livingEntity.m_21124_((MobEffect)ImmortalersDelightMobEffect.INCANDESCENCE.get())) != null) {
                    int lv = incandence.m_19564_();
                    int duration = incandence.m_19557_();
                    if (lv > 0) {
                        --lv;
                        duration = (int)((float)duration * 2.5f);
                    }
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)ImmortalersDelightMobEffect.COOL.get(), duration, lv));
                    FreezeEffect.applyImmortalEffect(livingEntity, 200, 0);
                }
                if (stack.m_41720_() == ImmortalersDelightItems.FROSTY_CROWN_MOUSSE_SLICE.get()) {
                    FreezeEffect.applyImmortalEffect(livingEntity, 200, 2);
                }
                if (stack.m_41720_() == ImmortalersDelightItems.FROZEN_MARGARITA_JELLY.get() && DifficultyModeUtil.isPowerBattleMode()) {
                    livingEntity.m_21153_(livingEntity.m_21223_() + 4.0f);
                }
                if (stack.m_41720_() == ImmortalersDelightItems.BOWL_OF_THIS_SIDE_DOWN.get()) {
                    if (!livingEntity.m_6084_()) {
                        return;
                    }
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        CompoundTag tag = player.getPersistentData();
                        tag.m_128379_(EAT_THIS_SIDE_DOWN, true);
                    }
                }
            }
        }
    }

    public static void shootKiBlast(LivingEntity attacker) {
        LivingEntity livingEntity = attacker;
        Level level = livingEntity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List list = livingEntity.m_9236_().m_45976_(LivingEntity.class, new AABB(livingEntity.m_20097_()).m_82377_(3.0, 3.0, 3.0));
            if (!list.isEmpty()) {
                for (LivingEntity hurtOne : list) {
                    if (hurtOne == livingEntity || livingEntity.m_7307_((Entity)hurtOne) || hurtOne.m_7307_((Entity)livingEntity)) continue;
                    float damage = (float)hurtOne.m_21133_(Attributes.f_22281_);
                    damage = Math.min(damage, 5.0f) * (DifficultyModeUtil.isPowerBattleMode() ? 3.85f : 2.3f);
                    hurtOne.m_6469_(hurtOne.m_9236_().m_269111_().m_269333_(livingEntity), damage);
                    FoodItemEventHelper.strongKnockback(hurtOne, livingEntity);
                }
            }
            FoodItemEventHelper.spawnShriekParticle(serverLevel, livingEntity.m_20185_(), livingEntity.m_20186_() + (double)(livingEntity.m_20192_() * 0.5f), livingEntity.m_20189_(), 1);
        }
        Vec3 lookDirection = livingEntity.m_20252_(1.0f);
        double spawnX = livingEntity.m_20185_() + lookDirection.f_82479_;
        double spawnY = livingEntity.m_20188_() + lookDirection.f_82480_;
        double spawnZ = livingEntity.m_20189_() + lookDirection.f_82481_;
        KiBlastEntity fireball = new KiBlastEntity(livingEntity.m_9236_(), livingEntity, lookDirection.f_82479_ * 0.5, lookDirection.f_82480_ * 0.5, lookDirection.f_82481_ * 0.5);
        if (DifficultyModeUtil.isPowerBattleMode()) {
            fireball.setDangerous(true);
        }
        fireball.m_6034_(spawnX, spawnY, spawnZ);
        livingEntity.m_9236_().m_7967_((Entity)fireball);
    }

    public static void spawnShriekParticle(ServerLevel serverLevel, double x, double y, double z, int delay) {
        ShockWaveParticleOption particleOption = new ShockWaveParticleOption(delay);
        serverLevel.m_8767_((ParticleOptions)particleOption, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static void strongKnockback(LivingEntity hurtOne, LivingEntity attacker) {
        double knockBackResistance = hurtOne.m_21133_(Attributes.f_22278_);
        if (DifficultyModeUtil.isPowerBattleMode()) {
            if (knockBackResistance < 1.0) {
                Vec3 directionVector = hurtOne.m_20318_(1.0f).m_82546_(attacker.m_20318_(1.0f));
                double distance = attacker.m_20280_((Entity)hurtOne);
                hurtOne.m_20256_(hurtOne.m_20184_().m_82520_(directionVector.f_82479_ / (1.0 + 0.2 * distance) * (1.0 - knockBackResistance), 0.5, directionVector.f_82481_ / (1.0 + 0.2 * distance) * (1.0 - knockBackResistance)));
                hurtOne.m_146922_(hurtOne.f_20885_);
                hurtOne.m_6853_(false);
                hurtOne.f_19812_ = true;
            }
        } else {
            if (knockBackResistance > (double)hurtOne.m_217043_().m_188501_()) {
                return;
            }
            double d0 = hurtOne.m_20185_() - attacker.m_20185_();
            double d1 = hurtOne.m_20189_() - attacker.m_20189_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            hurtOne.m_5997_(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
        }
    }

    @SubscribeEvent
    public static void onLivingRemoveEffect(MobEffectEvent.Remove event) {
        CompoundTag tag;
        LivingEntity livingEntity = event.getEntity();
        MobEffect removingOne = event.getEffect();
        if ((removingOne == MobEffects.f_19613_ || removingOne == MobEffects.f_19599_) && (tag = livingEntity.getPersistentData()).m_128441_(EAT_THIS_SIDE_DOWN)) {
            if (livingEntity.m_21023_((MobEffect)ImmortalersDelightMobEffect.UP_SIDE_DOWN.get())) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            } else {
                tag.m_128473_(EAT_THIS_SIDE_DOWN);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent evt) {
        if (evt.isCanceled() || evt.getSource().m_269533_(DamageTypeTags.f_268630_)) {
            return;
        }
        boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
        LivingEntity hurtOne = evt.getEntity();
        LivingEntity attacker = null;
        Entity entity = evt.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity;
            attacker = livingEntity = (LivingEntity)entity;
        }
        if (!hurtOne.m_9236_().f_46443_ && hurtOne.m_21211_().m_41720_() == ImmortalersDelightItems.EVOLUTCORN_HARD_CANDY.get() && hurtOne.m_21252_() > (isPowerful ? 16 : 32)) {
            float buffer = (isPowerful ? 0.4f : 0.6f) - (isPowerful ? 0.6f : 0.4f) * (float)hurtOne.m_21252_() / (float)hurtOne.m_21211_().m_41779_();
            if (buffer > 0.0f) {
                evt.setAmount(evt.getAmount() * buffer);
            } else {
                if (isPowerful) {
                    hurtOne.m_5634_(evt.getAmount() * buffer * -1.0f);
                }
                evt.setAmount(0.0f);
                evt.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerFeed(PlayerInteractEvent.EntityInteractSpecific event) {
        block8: {
            ServerLevel serverLevel;
            ItemStack itemStack;
            Player player;
            LivingEntity target;
            block10: {
                block9: {
                    Entity entity;
                    if (event.getEntity() == null || !((entity = event.getTarget()) instanceof LivingEntity)) break block8;
                    target = (LivingEntity)entity;
                    player = event.getEntity();
                    Level level = player.m_9236_();
                    itemStack = event.getItemStack();
                    if (!(level instanceof ServerLevel)) break block9;
                    serverLevel = (ServerLevel)level;
                    if (itemStack != ItemStack.f_41583_) break block10;
                }
                return;
            }
            if (itemStack.m_41720_() == ImmortalersDelightItems.CLEAR_WATER_VODKA.get()) {
                InebriatedToxicFoodItem.addInebriatedEffect(itemStack, (Level)serverLevel, target);
                if (itemStack.getCraftingRemainingItem() != ItemStack.f_41583_ && !player.m_7500_()) {
                    player.m_36356_(itemStack.getCraftingRemainingItem());
                    itemStack.m_41774_(1);
                }
            }
            if (itemStack.m_41720_() == ImmortalersDelightItems.GOLDEN_KWAT_TOAST.get() && target instanceof PiglinBrute) {
                PiglinBrute piglin = (PiglinBrute)target;
                player.m_7292_(new MobEffectInstance((MobEffect)ImmortalersDelightMobEffect.ESTEEMED_GUEST.get(), 48000, 1));
                piglin.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)ImmortalersDelightItems.GOLDEN_KWAT_TOAST.get()));
                CompoundTag tag = piglin.getPersistentData();
                if (tag.m_128423_(DELETE_PIGLIN) == null) {
                    tag.m_128356_(DELETE_PIGLIN, TimekeepingTask.getImmortalTickTime().longValue());
                }
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        AbstractPiglin piglin;
        LivingEntity livingEntity;
        if (!event.getEntity().m_9236_().m_5776_() && (livingEntity = event.getEntity()) instanceof AbstractPiglin && (piglin = (AbstractPiglin)livingEntity).getPersistentData().m_128425_(DELETE_PIGLIN, 4)) {
            if (TimekeepingTask.getImmortalTickTime() % 500L <= 50L) {
                FoodItemEventHelper.spawnParticle(piglin.m_9236_(), piglin.m_20183_(), 0);
            }
            if (TimekeepingTask.getImmortalTickTime() >= 4000L + piglin.getPersistentData().m_128454_(DELETE_PIGLIN)) {
                for (int i = 0; i < 2; ++i) {
                    FoodItemEventHelper.spawnParticle(piglin.m_9236_(), piglin.m_20183_(), 1);
                }
                piglin.m_9236_().m_7785_(piglin.m_20185_(), piglin.m_20186_(), piglin.m_20189_(), SoundEvents.f_12241_, SoundSource.HOSTILE, 0.8f, 0.8f, false);
                piglin.m_146870_();
            }
        }
    }

    private static void spawnParticle(Level level, BlockPos pPos, int type) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 center = new Vec3((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5);
            double radius = 0.32 + (double)type;
            for (int i = 0; i < 3 + 12 * type; ++i) {
                double angle = Math.PI * 2 * Math.random();
                double r = radius * Math.sqrt(Math.random());
                double x = center.f_82479_ + r * Math.cos(angle);
                double z = center.f_82481_ + r * Math.sin(angle);
                double y = center.f_82480_;
                if (type == 0) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, x, y, z, 1, 0.0, 0.0, 0.0, 0.025);
                }
                if (type != 1) continue;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, x, y, z, 1, 0.0, 0.0, 0.0, 0.025);
            }
        }
    }
}

